#ifndef SYSTEM_H
#define SYSTEM_H

#include "User_api.h"
#include "Gradient_generator.h"
#include "Log.h"
#include <ctime>
#include "windows.h"
#include "psapi.h"
#include <thread>

NN_data NN_DATA;
User_parameter USER_PARAMETER;
NN_parameter NN_PARAMETER;
app1_indata INDATA = { {}, {}, {} };
app1_solution SOLUTION = { {},{},{},{},{} };
app1_gradient GRADIENT = { {}, {}, {} };
problem pr;
User_api USER_API("NN_function", &NN_DATA, &USER_PARAMETER, &NN_PARAMETER, &GRADIENT);



void POF_INITIALIZATION(int* n_dataset_index) {
	cout << "\n  System:: INITIALIZATION start" << endl;
		USER_API.load_dataset(n_dataset_index);
		cout << "  System:: INITIALIZATION complete\n" << endl;
}


void POF_TRAIN_BATCH(vector<int> train_sample_index_array, vector<int> train_internal_test_index_array,
	double dropout, double alpha, double lr, double weight_decay,
	int n_rank, double th, double beta, double lambda, double xi, ...) {
	Loss_generator LOSS_GENERATOR(pr, &NN_DATA, &USER_PARAMETER, &INDATA, &SOLUTION);
	Gradient_generator GRADIENT_GENERATOR(pr, &NN_DATA, &USER_PARAMETER, &INDATA, &SOLUTION, &GRADIENT);
	cout << "\n  System:: TRAIN(1STEP) start" << endl;
	clock_t start = std::clock();
	USER_API.set_nnparameters(dropout, alpha, lr, weight_decay);
	USER_API.update_nndata_batch(1, train_sample_index_array, train_internal_test_index_array);
	int n_sample = USER_API.get_userparameter_int("n_sample");
	int n_internal_test_case = static_cast<int>(train_internal_test_index_array.size());
	double* context_tmp = new double[n_label * n_rank];
	va_list context_list;
	va_start(context_list, xi);
	double arg = 0.;
	for (int i = 0; i < n_label * n_rank; i++) {
		arg = va_arg(context_list, double);
		context_tmp[i] = arg;
	}
	USER_API.set_userparameters(n_internal_test_case, n_rank, th,  beta, lambda, xi, context_tmp);
	delete[] context_tmp;
	normaltable nt;
	nt = calc_normaltable(NN_DATA, USER_PARAMETER, &INDATA);
	normalclass nc;
	nc = calc_normalclass(NN_DATA, &INDATA);
	posterior p;
	p = calc_posterior(NN_DATA, USER_PARAMETER, &INDATA, nt);
	INDATA.nt = nt;
	INDATA.nc = nc;
	INDATA.p = p;
	GRADIENT_GENERATOR.clear();
	SOLUTION = { {},{},{},{},{} };
	double approx_loss = 0, best_loss = 0, ulti_best_loss = 0;
	for (int sample_order = 0;sample_order < NN_DATA.n_sample;sample_order++)
	{
		approx_loss += LOSS_GENERATOR.calc_approx_loss_batch(sample_order, INDATA.nc, INDATA.p, 1);
					}
	int max_vio = 0;
	for (int l = 0;l < 4;l++)
		max_vio = max_vio > SOLUTION.vio[l] ? max_vio : SOLUTION.vio[l];
	write_log("TRAIN", th, approx_loss, max_vio);
	GRADIENT_GENERATOR.calc_grad_expected_demand();
	GRADIENT_GENERATOR.calc_grad_ccon_batch();
	GRADIENT_GENERATOR.calc_grad_test_case_ccon();
	for (int l = 0;l < n_label;l++)
	{
		double gradsum_for_bias[10] = {};
		for (int j = 0; j < USER_PARAMETER.n_internal_test_case; j++) {
			for (int i = 0; i < NN_DATA.n_class; i++) {
				gradsum_for_bias[i] += GRADIENT.test_case_ccon_gradient[l][i][j];
			}
		}
		for (int j = 0; j < USER_PARAMETER.n_internal_test_case; j++) {
			for (int i = 0; i < NN_DATA.n_class; i++) {
				GRADIENT.test_case_ccon_gradient[l][i][j] -= gradsum_for_bias[i] / USER_PARAMETER.n_internal_test_case;
			}
		}
	}
	USER_API.backpropagation(2);
	USER_API.set_userparameter("lambda_decay", 0.999);
	cout << "  System:: TRAIN(1STEP) complete" << endl;
}

app1_solution POF_UTILIZATION(int mode, vector<int> val_sample_index_array, vector<int> internal_test_index_array,
	int n_rank, double th,  double beta, double lambda, double xi, ...) {
	Loss_generator LOSS_GENERATOR(pr, &NN_DATA, &USER_PARAMETER, &INDATA, &SOLUTION);
	Gradient_generator GRADIENT_GENERATOR(pr, &NN_DATA, &USER_PARAMETER, &INDATA, &SOLUTION, &GRADIENT);
	cout << "\n  System:: UTILIZATION(1STEP) start" << endl;
	int n_internal_test_case = static_cast<int>(internal_test_index_array.size());
	double* context_tmp = new double[n_label * n_rank];
	va_list context_list;
	va_start(context_list, xi);
	double arg = 0.;
	for (int i = 0; i < n_label * n_rank; i++) {
		arg = va_arg(context_list, double);
		context_tmp[i] = arg;
	}
	USER_API.set_userparameters(n_internal_test_case, n_rank, th,  beta, lambda, xi, context_tmp);
	delete[] context_tmp;
	SOLUTION = { {},{},{},{},{} };
	USER_API.update_nndata_batch(2, val_sample_index_array, internal_test_index_array);
	normaltable nt;
	nt=calc_normaltable(NN_DATA, USER_PARAMETER, &INDATA, mode);
	posterior p;
	p = calc_posterior(NN_DATA, USER_PARAMETER, &INDATA, nt);
	double bias[n_label] = {};
	int sel[n_label] = {};
	for (int l = 0;l < n_label;l++)
	{
		double ori_post = 0;
		

		double min = 1e9;

		for (int i = 0; i < NN_DATA.n_class; i++)
		{
			if (min > p.postprob[l][i][1])
			{
				min = p.postprob[l][i][1];
				sel[l] = i;
			}
		}
		ori_post = min;
		if (min > th)
		{
			while (p.postprob[l][sel[l]][1] > th && bias[l] > -20)
			{
				for (int j = 0; j < USER_PARAMETER.n_internal_test_case; j++)
					NN_DATA.test_case_ccon_w[l][sel[l]][j] -= 0.001;
				bias[l] -= 0.001;
				nt = calc_normaltable(NN_DATA, USER_PARAMETER, &INDATA, mode);
				p = calc_posterior(NN_DATA, USER_PARAMETER, &INDATA, nt);
			}
		}
		if (min < th)
		{
			while (p.postprob[l][sel[l]][1] < th && bias[l] < 20)
			{
				for (int j = 0; j < USER_PARAMETER.n_internal_test_case; j++)
					NN_DATA.test_case_ccon_w[l][sel[l]][j] += 0.001;
				bias[l] += 0.001;
				nt = calc_normaltable(NN_DATA, USER_PARAMETER, &INDATA, mode);
				p = calc_posterior(NN_DATA, USER_PARAMETER, &INDATA, nt);
			}
		}
		while (p.postprob[l][sel[l]][1] > th && bias[l] > -20)
		{
			for (int j = 0; j < USER_PARAMETER.n_internal_test_case; j++)
				NN_DATA.test_case_ccon_w[l][sel[l]][j] -= 0.001;
			bias[l] -= 0.001;
			nt = calc_normaltable(NN_DATA, USER_PARAMETER, &INDATA, mode);
			p = calc_posterior(NN_DATA, USER_PARAMETER, &INDATA, nt);
		}
		ori_post = min;
		printf("%d\t%lf\t%lf\n", sel[l], ori_post, bias[l]);
		for (int j = 0; j < NN_DATA.n_sample; j++)
		{
			NN_DATA.ccon_w_batch[l][sel[l]][j] += bias[l];
		}
	}
	nt = calc_normaltable(NN_DATA, USER_PARAMETER, &INDATA, mode);
	p = calc_posterior(NN_DATA, USER_PARAMETER, &INDATA, nt);
	
	for (int l = 0;l < n_label;l++)
		if (bias[l] < -19.8)
			p.postprob[l][sel[l]][1] = 0;
	
	normalclass nc;
	nc=calc_normalclass(NN_DATA, &INDATA);
	
	INDATA.nt = nt;
	INDATA.nc = nc;
	INDATA.p = p;
	
	for (int sample_order = 0;sample_order < NN_DATA.n_sample;sample_order++)
	{
		LOSS_GENERATOR.ulti_best_loss_batch(sample_order, INDATA.nc, INDATA.p);
		LOSS_GENERATOR.best_loss_batch(sample_order, INDATA.nc, INDATA.p);
		LOSS_GENERATOR.get_solution(sample_order, nc, p);
	}
	cout << "  System:: UTILIZATION(1STEP) complete\n" << endl;
	return SOLUTION;
}

void POF_FINALIZATION() {
	cout << "\n  System:: FINALIZATION start" << endl;
	USER_API.clear();
	close_log_loss_file();
	cout << "  System:: FINALIZATION complete\n" << endl;
}

#endif
